﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class FruitItemView : MonoBehaviour
{
    public FruitType m_type;
    public FruitType type => m_type;

    private Vector3 m_size;
    public Vector3 Size => m_size;
    private MeshRenderer m_meshRender;
    private GameObject m_childObj;
    private MeshRenderer[] m_fragTrans;//碎块
    private List<Vector3> m_fragPos = new List<Vector3>();//碎块初始位置
    private List<Quaternion> m_fragQua = new List<Quaternion>();//碎块初始旋转
    private void Awake()
    {
        m_size = transform.localScale;
        m_meshRender = GetComponent<MeshRenderer>();
        m_childObj = transform.GetChild(0).gameObject;
        m_fragTrans = m_childObj.GetComponentsInChildren<MeshRenderer>();
        for(int i = 0;i<m_fragTrans.Length;i++)
        {
            Transform varTrans = m_fragTrans[i].transform;
            m_fragPos.Add(varTrans.localPosition);
            m_fragQua.Add(varTrans.localRotation);
        }
    }
    //变大动画
    public void SetChangeBig()
    {
        transform.localScale = Vector3.Lerp(transform.localScale, m_size * 1.1f, 1.0f);
    }
    //变小动画
    public void SetChangeSmall()
    {
        transform.localScale = Vector3.Lerp(transform.localScale, m_size, 1.0f);
    }
    //生成碎块
    public void SetFrag()
    {
        if(m_meshRender)
        {
            m_meshRender.enabled = false;
        }
        if(m_childObj)
        {
            m_childObj.SetActive(true);
        }
    }
    //重置碎块状态
    public void ResetFragState()
    {
        if (m_meshRender)
        {
            m_meshRender.enabled = true;
        }
        if (m_childObj)
        {
            m_childObj.SetActive(false);
        }
        for (int i = 0; i < m_fragTrans.Length; i++)
        {
            m_fragTrans[i].transform.localPosition = m_fragPos[i];
            m_fragTrans[i].transform.localRotation = m_fragQua[i];
        }
    }
}
